import { StarConnectionSettings } from "./StarConnectionSettings";
import { StarPrinterStatus } from "./star-printer-status/";
import { StarPrinterInformation } from "./star-printer-information";
import { aaca0adc50034daa9 } from "./internal/a7917fe845517cd99/aaca0adc50034daa9";
import { GetInformationOptions, GetStatusOptions, OpenOptions, PrintOptions } from "./options";
export declare class StarPrinter {
    private _starPrinterWorker;
    private get starPrinterWorker();
    private checkStarPrinterWorker;
    private _starXpandCommandParserWorker;
    private get starXpandCommandParserWorker();
    private checkStarXpandCommandParserWorker;
    private _connectionSettings;
    get connectionSettings(): StarConnectionSettings;
    set connectionSettings(connectionSettings: StarConnectionSettings);
    constructor(connectionSettings: StarConnectionSettings, commandParserWorker?: Worker | null);
    open(options?: OpenOptions): Promise<void>;
    close(): Promise<void>;
    dispose(): Promise<void>;
    printRawData(data: Uint8Array, options?: PrintOptions): Promise<void>;
    print(command: string, options?: PrintOptions): Promise<void>;
    getStatus(options?: GetStatusOptions): Promise<StarPrinterStatus>;
    setInformation(information: StarPrinterInformation): Promise<void>;
    getInformation(options?: GetInformationOptions): Promise<StarPrinterInformation>;
    getInformationInternal(options?: GetInformationOptions): Promise<aaca0adc50034daa9>;
    private createWorkerTaskID;
    private startLogging;
    private stopLogging;
    private syncStarLogger;
}
